/*----------------------------------------------------------------------

  Prefs.h

  ----------------------------------------------------------------------

  Copyright (C). 2003 Smoky Monkey Factory All Rights Reserved
  http://andmore.jp/mobile/

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id: Prefs.h,v 1.5 2003/07/20 01:58:38 zxn Exp $

  ----------------------------------------------------------------------*/

#include <PalmOS.h>
#define PREF_VERSION 2

typedef void * prefsObj;

typedef enum
  {
    PREFS_AUTO_ACTIVATE_YES=0,
    PREFS_AUTO_ACTIVATE_NO=1,
    PREFS_AUTO_ACTIVATE_ASK=2
  } prefsAutoActivateIdx;

prefsObj prefs_New(void);
void prefs_Delete(prefsObj prefs);

void prefs_Save(prefsObj);

Boolean prefs_GetEnabled(prefsObj);
void prefs_SetEnabled(prefsObj prefs, Boolean enabled);

prefsAutoActivateIdx prefs_GetAutoActivate(prefsObj);
void prefs_SetAutoActivate(prefsObj prefs, prefsAutoActivateIdx stat);

void prefs_InitFldEnter(prefsObj);
void prefs_SetFldEnter(prefsObj prefs, Boolean newFldEnterStat);
Boolean prefs_GetFldEnter(prefsObj);
